-- Vim options
vim.opt.tabstop = 2
vim.opt.shiftwidth = 2
vim.opt.expandtab = true

vim.opt.number = true
vim.opt.relativenumber = true

vim.opt.cursorline = true


-- Plugins using vim-plug
local Plug = vim.fn['plug#']
vim.call('plug#begin')

Plug('tanvirtin/monokai.nvim')

Plug('tpope/vim-sensible')

Plug('tpope/vim-surround')

Plug('famiu/feline.nvim')

Plug('preservim/nerdtree')

Plug('tpope/vim-fugitive')

-- https://github.com/willothy/nvim-cokeline
-- Plug 'willothy/nvim-cokeline'

-- sudo apt install fzf
Plug('junegunn/fzf.vim')

vim.call('plug#end')


-- Setup feline
vim.opt.termguicolors = true
require('feline').setup()


-- Set color scheme
vim.cmd('colorscheme monokai')
